//
//  TTable.h
//  GSFontTools
//
//  Created by Georg Seifert on 24.07.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class TTFont;
@class GSXMLWriter;

@interface TTable : NSObject {
	NSError *_error;
	NSArray *_glyphOrder;
	NSString *_tableTag;
	NSData *_cachedData;
	NSUInteger _originalSize;
}

@property (retain, nonatomic) NSError *error;
@property (retain, nonatomic) NSArray *glyphOrder;
@property (copy, nonatomic) NSString *tableTag;
@property (nonatomic, assign) NSUInteger originalSize;
@property (nonatomic, strong) NSData *cachedData;

- (id)initWithTag:(NSString *)tag;

+ (NSArray *)dependencies;

- (void)toXML:(GSXMLWriter *)writer font:(TTFont *)font;

- (void)fromXML:(NSString *)name attrs:(NSDictionary *)attrs content:(id)content font:(TTFont *)font;

- (BOOL)decompile:(NSData *)data font:(TTFont *)font error:(NSError **)error;

- (NSData *)compile:(TTFont *)font error:(NSError **)error;

@end

@interface DefaultTable : TTable

@end
